# -*- coding: utf-8 -*-

# Copyright 2015-2016 Mir Calculate. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from calculate.lib.datavars import DataVars
from calculate.lib.utils.tools import AddonError

from calculate.lib.cl_lang import setLocalTranslate

setLocalTranslate('cl_builder3', sys.modules[__name__])

builder_data = "/var/lib/calculate/calculate-builder"


class BuilderError(AddonError):
    """Builder Error"""


class DataVarsBuilder(DataVars):
    """Variable class for desktop package"""
    var_module = "builder"

    def importBuilder(self, **args):
        """Import desktop variables"""
        self.importVariables()
        self.importVariables('calculate.%s.variables' % self.var_module)
        self.defaultModule = self.var_module
